
![Logo](https://imgak.mmtcdn.com/pwa_v3/pwa_hotel_assets/header/mmtLogoWhite.png)

# Clone of Make my Trip

# Technology we use

## Backend
- Node Js
- Express
- MongoDB
- Nodemailer

## Frontend
- React
- Material UI
- Styled- components

## Apis

### Realtime flight search
Aviation Stack - [ aviationstack.com/](https://aviationstack.com/) 

### Otp Varification
Twilio -  [twilio.com/](https://www.twilio.com/) 

### Payment Gateway
Razorpay -  [razorpay.com/](https://razorpay.com/) 

### Mail Service 
NodeMailer -  [nodemailer.com/](https://nodemailer.com/) 

## Color Reference

| Color             | Hex                                                                |
| ----------------- | ------------------------------------------------------------------ |
| Primary Color  | ![#eb2226](https://via.placeholder.com/10/eb2226?text=+) #eb2226 |
| Backgroud color | ![#ffffff](https://via.placeholder.com/10/ffffff?text=+) #ffffff |
| Icons color and button color| ![#48a6fd](https://via.placeholder.com/10/48a6fd?text=+) #48a6fd |



## Run Locally

Clone the project

```bash
  git clone https://link-to-project
```

Go to the project directory

```bash
  cd backend/frontend
```

Install dependencies

```bash
  npm install
```

Start the server

```bash
  npm start
```


## Environment Variables

To run this project, you will need to add the following environment variables to your .env file

### Backend

`mongo` - database

`port` - running port

`RAZORPAY_KEY_ID`

`RAZORPAY_KEY_SECRET`

`CURRENT_ENVIRONMENT`

`SMTP_USERNAME`

`SMTP_PASSWORD`

`SMTP_PORT`


### Frontend

`RAZORPAY_KEY_ID`

`RAZORPAY_KEY_SECRET`

`PORT`


## Features

- Login and Sign up using Mobile OTP
- Search engine to search Flights
- Sorting of flights as his price
- Apply the coupon on your cart 
- Purchase the Product
- Do payment with any type of method(Card/UPI/Net-banking)


## Acknowledgements

 - [makemytrip.com](https://www.makemytrip.com/)
 - [Masai School](https://masaischool.com/)
  

## Authors

-  [Arpit Sachan](https://github.com/sachanarpit/)

- [Dharmesh Yadav](https://github.com/dharmeshrao)

- [Rahul Kumar Yadav](https://github.com/rahulyadav96)


## Home Page


![screencapture-localhost-3005-2021-11-13-20_06_05.png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819763376/zjIHEBDE0.png)


## Login and Otp verification

![Screenshot (39).png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819827776/BVzkKdcMk.png)
![Screenshot (40).png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819833599/lmidFgXps.png)
![e5af704b-7928-4a7a-862f-98b69ef92d5b.jpg](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819849756/g819xGufS.jpeg)


## Search Page

![screencapture-localhost-3005-search-2021-11-13-20_08_52.png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819783064/o0BPrMowgc.png)
![Screenshot (42)](https://user-images.githubusercontent.com/87421773/141656488-8910d26d-c2e8-4678-92e5-4d00641ecdac.png)

##Payment Page

![screencapture-localhost-3005-checkout-2021-11-13-20_53_49](https://user-images.githubusercontent.com/87421773/141656572-8077485c-c55a-4a89-a26a-5e0d714d4d46.png)

![screencapture-localhost-3005-final-2021-11-13-20_10_22.png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819919150/eUj6IOOoc.png)

![screencapture-localhost-3005-final-2021-11-13-20_10_48.png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819925472/eRRCvR1Dr.png)

![image.png](https://cdn.hashnode.com/res/hashnode/image/upload/v1636819997027/85PGB_l7i.png)


- GITHUB - https://github.com/sachanarpit/make-my-trip
